import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { queryResponse } from "../../util/processResponse.js";

const initialState = {
    myReviews: [],
    loading: false,
    isRefresh: false,
    nextPageUrl: "",
    loadMore: false,
};

export const getMyReviews = createAsyncThunk(
    "user/getMyReviews",
    async (dataObj) => {
        const { access_token, URL } = dataObj;
        const response = await queryResponse(URL, "GET", access_token);
        return response;
    }
);
export const getMoreReviews = createAsyncThunk(
    "user/getMoreReviews",
    async (dataObj) => {
        const { access_token, URL } = dataObj;
        const response = await queryResponse(URL, "GET", access_token);
        return response;
    }
);

const getMyReviewsSlice = createSlice({
    name: "user",
    initialState,
    reducers: {
        resetMyReviews: (state) => {
            state.myReviews = [];
            state.loading = true;
            state.isRefresh = false;
        },
        fetchReviewStart: (state) => {
            state.isRefresh = true;
        },
        getMyReviewsSuccree: (state, { payload }) => {
            state.myReviews = payload;
            state.isRefresh = false;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getMyReviews.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getMyReviews.fulfilled, (state, { payload }) => {
            const {
                status: { code } = {},
                records: { pagination, data } = {},
            } = payload || {};
            if (code === 200) {
                state.myReviews = data;
                state.nextPageUrl = pagination?.next_page_url;
            }
            state.loading = false;
        });
        builder.addCase(getMyReviews.rejected, (state) => {
            state.loading = false;
        });
        builder.addCase(getMoreReviews.pending, (state) => {
            state.loadMore = true;
        });
        builder.addCase(getMoreReviews.fulfilled, (state, { payload }) => {
            const {
                status: { code } = {},
                records: { pagination, data } = {},
            } = payload || {};
            if (code === 200) {
                state.myReviews = [...state.myReviews, ...data];
                state.nextPageUrl = pagination?.next_page_url;
            }
            state.loadMore = false;
        });
        builder.addCase(getMoreReviews.rejected, (state) => {
            state.loadMore = false;
        });
    },
});

export const { resetMyReviews, fetchReviewStart, getMyReviewsSuccree } =
    getMyReviewsSlice.actions;
export default getMyReviewsSlice.reducer;
